/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org2.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;

public class XDebugLaunchListener
implements ILaunchesListener {
    private static final String SYSTEM_DEBUG_PROPERTY = IDELayerFactory.getIDELayer().getSystemDebugProperty();
    private static XDebugLaunchListener instance;
    private boolean webLaunchActive;

    private XDebugLaunchListener() {
    }

    public static XDebugLaunchListener getInstance() {
        if (instance == null) {
            instance = new XDebugLaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)instance);
        }
        return instance;
    }

    public static void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)instance);
    }

    public void launchesAdded(ILaunch[] launches) {
        this.updateStatus(launches, true);
    }

    public void launchesChanged(ILaunch[] launches) {
        this.updateStatus(launches, true);
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.updateStatus(launches, false);
    }

    public void updateStatus(ILaunch[] launches, boolean added) {
        boolean hasActiveLaunch = false;
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget target = launch.getDebugTarget();
            if (target instanceof IDBGpDebugTarget && ((IDBGpDebugTarget)target).isWebLaunch()) {
                this.webLaunchActive = added;
            }
            hasActiveLaunch |= !launch.isTerminated();
            ++i;
        }
        System.setProperty(SYSTEM_DEBUG_PROPERTY, hasActiveLaunch ? "true" : "false");
    }

    public boolean isWebLaunchActive() {
        return this.webLaunchActive;
    }
}

